package ie.ucd.sixth.adaptor.wasp;

import ie.ucd.sixth.core.adaptor.IMessageTranslator;
import ie.ucd.sixth.core.adaptor.SensorMessageTranslationException;
import ie.ucd.sixth.core.sensor.data.Modality;
import ie.ucd.sixth.core.sensor.data.ISensorData;
import ie.ucd.sixth.core.sensor.data.Modality;
import ie.ucd.sixth.core.sensor.data.SensorData;

import java.util.HashMap;
import java.util.List;
import java.util.Vector;

public class WaspMessageTranslator implements IMessageTranslator<String> {

	@Override
	public List<ISensorData> translateMessage(String input)
			throws SensorMessageTranslationException {
		List<ISensorData> list = new Vector<ISensorData>();
		if (input != null) {

			int ibeginIndex = input.indexOf("-ID");
			input = input.substring(ibeginIndex);
			int idIndex = input.indexOf("-ID");
			String sensorID = input.substring(idIndex + 4, idIndex + 11);
			int nodeID = Integer.parseInt(sensorID, 16);
			String[] valuesArray = input.split(",");
			HashMap<Modality, String> valuesMap = new HashMap<Modality, String>();
			for (String string : valuesArray) {
				String[] modVal = string.split(":");
				valuesMap.put(new Modality(modVal[0].trim()), modVal[1].replaceAll("%", ""));
			}
			valuesMap.remove("-ID");
			valuesMap.put(Modality.ACCELERATION_X, valuesMap.get("-x"));
			valuesMap.put(Modality.ACCELERATION_Z, valuesMap.get("y"));
			valuesMap.put(Modality.ACCELERATION_Y, valuesMap.get("z"));
			valuesMap.put(Modality.TEMPERATURE, valuesMap.get("-temp"));
			valuesMap.put(new Modality("Battery"), valuesMap.get("-bat"));
			String[] remove = { "-x", "y", "z", "-temp", "-bat" };
			for (String string : remove)
				valuesMap.remove(string);
			SensorData data = new SensorData("Wasp", nodeID, new Modality("Wasp"),
					valuesMap, ISensorData.TYPE_PERIODIC);
			list.add(data);
			return list;
		} else {
			throw new SensorMessageTranslationException();
		}
	}

}
